/** @file   saveslot.cpp
 * @brief   Implementation of SaveSlot class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:47 $
 * @author  Tomi Lamminsaari
 */

#include "saveslot.h"
#include "consts.h"
#include <fstream>
using std::ifstream;
using std::string;


namespace WeWantWar {

/** Constructs new SaveSlot
 */
SaveSlot::SaveSlot(int slotnum) :
  m_slotnum( slotnum ),
  m_slotFile( "" ),
  m_slotContent( -1 )
{
  m_slotFile = Consts::saveSlotFiles.at( slotnum );

  ifstream fin( m_slotFile.c_str() );
  if ( !fin ) {
    return;
  }
  
  string tmp;
  fin >> tmp;
  if ( tmp != "[WE_WANT_WAR_SAVEFILE]" ) {
    fin.close();
    return;
  }
  fin >> tmp;
  if ( tmp != "level:" ) {
    fin.close();
    return;
  }
  
  fin >> tmp;
  m_slotContent = atoi( tmp.c_str() );
  fin.close();
}


/** Copy constructor
 */
SaveSlot::SaveSlot(const SaveSlot& ss) :
  m_slotnum( ss.m_slotnum ),
  m_slotFile( ss.m_slotFile ),
  m_slotContent( ss.m_slotContent )
{
}


/** Destructor
 */
SaveSlot::~SaveSlot()
{
}


/** operator =
 */
SaveSlot& SaveSlot::operator = (const SaveSlot& ss)
{
  if ( this != &ss ) {
    m_slotnum = ss.m_slotnum;
    m_slotFile = ss.m_slotFile;
    m_slotContent = ss.m_slotContent;
  }
  return *this;
}
/** Returns the name of the savefile attached to this slot
 */
string SaveSlot::getSlotFile() const
{
  return m_slotFile;
}


/** Returns the number of the level that is saved to this saveslot.
 */
int SaveSlot::getSlotContent() const
{
  return m_slotContent;
}


} // end of namespace
